/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.service.impl;

import com.mongodb.gridfs.GridFSInputFile;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.Map;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.monitor.globalsetting.service.i;
import com.tp_link.eap.monitor.monitor.model.MapAp;
import com.tp_link.eap.monitor.monitor.model.MapApDetail;
import com.tp_link.eap.monitor.monitor.repo.ApRepository;
import com.tp_link.eap.monitor.monitor.repo.MapRepository;
import com.tp_link.eap.monitor.monitor.service.b;
import com.tp_link.eap.monitor.monitor.service.d;
import com.tp_link.eap.monitor.monitor.service.h;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.j.a;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Component(value="mapService")
public class MapService
implements h {
    @Autowired
    private MapRepository a;
    @Autowired
    private ApRepository b;
    @Autowired
    private b c;
    @Autowired
    private d d;
    @Autowired
    private i e;
    private static final Logger f = LoggerFactory.getLogger(MapService.class);

    @Override
    public OperationResponse getMapList(ControlType controlType, JSONObject reqObj) {
        List<Map> list = this.a.findBySite(com.tp_link.eap.d.b.a());
        if (CollectionUtils.isEmpty(list)) {
            this.a();
            list = this.a.findBySite(com.tp_link.eap.d.b.a());
        }
        HashMap<String, List<Map>> hashMap = new HashMap<String, List<Map>>();
        hashMap.put("data", list);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public List<Map> getMaps() {
        return this.a.findBySite(com.tp_link.eap.d.b.a());
    }

    @Override
    public Map getSelectMap() {
        List<Map> list = this.a.findByIsSelectedAndSite(true, com.tp_link.eap.d.b.a());
        if (list == null || list.isEmpty() || list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public boolean setSelectMap(String mapId, boolean selected) {
        Map map = this.getSelectMap();
        Map map2 = (Map)this.a.findOne((Serializable)((Object)mapId));
        if (map == null || map2 == null) {
            return false;
        }
        if (map.getId().equals(mapId)) {
            return true;
        }
        map.setSelected(false);
        this.a.save(map);
        map2.setSelected(true);
        this.a.save(map2);
        return true;
    }

    @Override
    public Map addMap(Map map) {
        if (map == null) {
            return null;
        }
        map.setSite(com.tp_link.eap.d.b.a());
        return (Map)this.a.save(map);
    }

    @Override
    public OperationResponse deleteMap(String mapId) {
        List<Map> list;
        Ap ap;
        List<Ap> list2;
        if (mapId == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Map map = (Map)this.a.findOne((Serializable)((Object)mapId));
        if (map == null) {
            return new OperationResponse(ResErrorCode.bc);
        }
        this.a.delete(map);
        String string = map.getFileId();
        if (null != string) {
            this.e.delGridFSFileById(new ObjectId(string));
        }
        if ((list2 = this.b.findByLocation_mapId(mapId)) != null && !list2.isEmpty()) {
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                ap = list2.get(i2);
                ap.getLocation().setLocated(false);
                ap.getLocation().setLocked(false);
                ap.getLocation().setMapId(null);
                this.b.save(ap);
            }
        }
        if (map.isSelected() && (list = this.getMaps()) != null && !list.isEmpty()) {
            ap = list.get(0);
            ap.setSelected(true);
            this.a.save(ap);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse refreshMap(Map map) {
        if (map == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        this.a.save(map);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public void deleteBySite() {
        List<Map> list = this.a.findBySite(com.tp_link.eap.d.b.a());
        if (!CollectionUtils.isEmpty(list)) {
            this.a.delete(list);
        }
    }

    @Override
    public Map getMap(String mapId) {
        if (mapId == null) {
            return null;
        }
        return (Map)this.a.findOne((Serializable)((Object)mapId));
    }

    @Override
    public OperationResponse getMapApList(ControlType controlType, JSONObject reqObj) {
        MapAp mapAp;
        int n2;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            f.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mapId");
        this.setSelectMap(string, true);
        List<Ap> list = this.c.getMapAps(string);
        ArrayList<MapAp> arrayList = new ArrayList<MapAp>();
        if (list != null) {
            for (n2 = 0; n2 < list.size(); ++n2) {
                mapAp = this.a(list.get(n2));
                if (mapAp == null) continue;
                arrayList.add(mapAp);
            }
        }
        if ((list = this.c.getUnLocatedAps()) != null) {
            for (n2 = 0; n2 < list.size(); ++n2) {
                mapAp = this.a(list.get(n2));
                if (mapAp == null) continue;
                arrayList.add(mapAp);
            }
        }
        HashMap<String, ArrayList<MapAp>> hashMap = new HashMap<String, ArrayList<MapAp>>();
        hashMap.put("data", arrayList);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse modifyMap(ControlType controlType, JSONObject reqObj) {
        String string;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            f.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string2 = jSONObject.opt("mapId") instanceof JSONNull ? null : jSONObject.optString("mapId");
        String string3 = string = jSONObject.opt("name") instanceof JSONNull ? null : jSONObject.optString("name");
        if (com.tp_link.eap.util.a.e.a((String)string2)) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.bi);
        }
        Map map = this.getMap(string2);
        if (map == null) {
            return new OperationResponse(ResErrorCode.bb);
        }
        map.setName(string);
        return this.refreshMap(map);
    }

    @Override
    public OperationResponse deleteMap(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            f.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mapId", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.deleteMap(string);
    }

    @Override
    public OperationResponse setMapPpm(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            f.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mapId", null);
        if (!jSONObject.containsKey((Object)"ppm") || !(jSONObject.get("ppm") instanceof Number)) {
            return new OperationResponse(ResErrorCode.d);
        }
        double d2 = jSONObject.getDouble("ppm");
        String string2 = null;
        if (!jSONObject.containsKey((Object)"dimension") || jSONObject.get("dimension") instanceof JSONNull) {
            return com.tp_link.eap.util.e.aZ;
        }
        string2 = jSONObject.optString("dimension");
        if (com.tp_link.eap.util.a.e.a((String)string) || d2 <= 0.0 || com.tp_link.eap.util.a.e.a((String)string2)) {
            return new OperationResponse(ResErrorCode.d);
        }
        Map map = this.getMap(string);
        if (map == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        map.setPpm(d2);
        map.setDimension(string2);
        this.refreshMap(map);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse selectMap(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            f.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mapId", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        boolean bl = this.setSelectMap(string, true);
        if (bl) {
            return com.tp_link.eap.util.e.bd;
        }
        return com.tp_link.eap.util.e.aZ;
    }

    @Override
    public void getMapFile(HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            f.warn("Invalid request, params is null");
            return;
        }
        String string = jSONObject.optString("mapId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return;
        }
        Map map = this.getMap(string);
        String string2 = map.getFileId();
        if (com.tp_link.eap.util.a.e.a((String)string2)) {
            f.warn("fileId is null");
            response.setStatus(404);
        } else {
            f.debug("Load: fileId {}", (Object)string2);
            try {
                boolean bl = this.e.getPictureFileFromGridfs(string2, response);
                if (!bl) {
                    f.warn("Load picture falied {}", (Object)string2);
                    response.setStatus(404);
                }
            }
            catch (Exception exception) {
                f.warn(exception.toString(), (Throwable)exception);
                response.setStatus(404);
            }
        }
    }

    @Override
    public OperationResponse getMapFile(String transferId, ControlType controlType, JSONObject reqObj, ChannelHandlerContext ctx) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            f.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("mapId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Map map = this.getMap(string);
        String string2 = map.getFileId();
        if (com.tp_link.eap.util.a.e.a((String)string2)) {
            f.warn("fileId is null");
            return com.tp_link.eap.util.e.aZ;
        }
        f.debug("Load: fileId {}", (Object)string2);
        try {
            boolean bl = this.e.getFileFromGridfsByCloud(string2, ctx, transferId);
            if (bl) {
                f.debug("Load picture by cloud success {}", (Object)string2);
                return com.tp_link.eap.util.e.bd;
            }
        }
        catch (Exception exception) {
            f.warn(exception.toString(), (Throwable)exception);
            return com.tp_link.eap.util.e.aY;
        }
        f.warn("Load map picture by cloud falied {}", (Object)string2);
        return com.tp_link.eap.util.e.aY;
    }

    @Override
    public OperationResponse addMap(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) throws Exception {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            f.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (this.a.count() >= 500L) {
            f.debug("map size {} has reached maximum", (Object)this.a.count());
            return new OperationResponse(ResErrorCode.bC);
        }
        if (this.e.checkGridFsReachMaxSize()) {
            return new OperationResponse(ResErrorCode.bI);
        }
        String string = jSONObject.optString("name");
        response.setCharacterEncoding("UTF-8");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.bi);
        }
        try {
            String string2 = this.addPictureFileToGridfs(request, 0xC00000L);
            if (null == string2) {
                return com.tp_link.eap.util.e.bg;
            }
            if (string2.equals("large")) {
                return new OperationResponse(ResErrorCode.bk);
            }
            Map map = new Map();
            map.setName(string);
            map.setFileId(string2);
            map.setPpm(0.0);
            map.setType(1);
            map = this.addMap(map);
            return new OperationResponse(ResErrorCode.a, (Object)map);
        }
        catch (Exception exception) {
            f.error("Map picture save file failed!");
            return com.tp_link.eap.util.e.bg;
        }
    }

    @Override
    public OperationResponse addMap(ControlType controlType, JSONObject reqData, String fileName, byte[] fileContent) {
        if (this.e.checkGridFsReachMaxSize()) {
            return new OperationResponse(ResErrorCode.bI);
        }
        JSONObject jSONObject = reqData.optJSONObject("params");
        if (jSONObject == null) {
            f.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        if (this.a.count() >= 500L) {
            f.debug("map size {} has reached maximum", (Object)this.a.count());
            return new OperationResponse(ResErrorCode.bC);
        }
        String string = jSONObject.optString("name");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.bi);
        }
        try {
            if ((long)fileContent.length > 0xC00000L) {
                f.warn("Too large({}) map file", (Object)fileContent.length);
                return new OperationResponse(ResErrorCode.bk);
            }
            InputStream inputStream = com.tp_link.eap.util.i.a.a((String)fileName, (InputStream)new ByteArrayInputStream(fileContent));
            if (inputStream == null) {
                return new OperationResponse(ResErrorCode.bj);
            }
            GridFSInputFile gridFSInputFile = this.e.saveGridFSFile(inputStream);
            if (gridFSInputFile == null) {
                f.warn("Failed to saveGridFSFile for map from cloud");
                return com.tp_link.eap.util.e.bg;
            }
            Map map = new Map();
            map.setName(string);
            map.setFileId(gridFSInputFile.getId().toString());
            map.setPpm(0.0);
            map.setType(1);
            map = this.addMap(map);
            f.debug("add map success");
            return new OperationResponse(ResErrorCode.a, (Object)map);
        }
        catch (Exception exception) {
            f.error("Cloud map picture save file failed!");
            return com.tp_link.eap.util.e.bg;
        }
    }

    @Override
    public OperationResponse getSelectedMap(ControlType controlType, JSONObject reqObj) {
        return new OperationResponse(ResErrorCode.a, (Object)this.getSelectMap());
    }

    @Override
    public OperationResponse checkMapOverLimit(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("data", this.a.count() >= 500L);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public List<Map> getAllMaps() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.a.findAll());
    }

    @Override
    public void addMaps(List<Map> maps) {
        this.a.save(maps);
    }

    @Override
    public void deleteAll() {
        this.a.deleteAll();
    }

    private void a() {
        Map map = new Map();
        map.setFile("./theme/img/map-demo.png");
        map.setFilePath("");
        map.setName("Default");
        map.setPpm(0.0);
        map.setDimension("m");
        map.setSelected(true);
        this.addMap(map);
    }

    private MapAp a(Ap ap) {
        if (ap == null) {
            return null;
        }
        if (ap.isAdopted()) {
            ArrayList<QueryFilter> arrayList = new ArrayList<QueryFilter>();
            arrayList.add(new QueryFilter("apMac", (Object)ap.getMac(), QueryFilter.FilterType.eq));
            arrayList.add(new QueryFilter("isActive", (Object)true, QueryFilter.FilterType.eq));
            arrayList.add(new QueryFilter("isGuest", (Object)false, QueryFilter.FilterType.eq));
            long l2 = this.d.count(arrayList, null);
            arrayList.remove(2);
            arrayList.add(new QueryFilter("isGuest", (Object)true, QueryFilter.FilterType.eq));
            long l3 = this.d.count(arrayList, null);
            MapApDetail mapApDetail = new MapApDetail(ap.getName(), ap.getMac(), ap.getIp(), this.b(ap), (int)l2, (int)l3, ap.getModel(), ap.getModelVersion());
            MapAp mapAp = new MapAp(ap, mapApDetail, true);
            return mapAp;
        }
        MapApDetail mapApDetail = new MapApDetail(ap.getName(), ap.getMac(), ap.getIp(), "N/A", 0, 0, ap.getModel(), ap.getModelVersion());
        MapAp mapAp = new MapAp(ap, mapApDetail, false);
        return mapAp;
    }

    private String b(Ap ap) {
        String string;
        String string2;
        String string3 = "N/A";
        String string4 = "";
        if (ap.getRadio() != null) {
            string4 = ap.getRadio().getChannel();
            if (!string4.equals("0")) {
                string2 = com.tp_link.eap.util.j.b.a((String)com.tp_link.eap.util.j.a.a((Integer)ap.getDeviceMisc().getCustomizeRegion()), (int)Integer.parseInt(string4), (boolean)true);
                if (string2 != null && !(string = this.a(string2)).equals("N/A")) {
                    string3 = string + "(2.4GHz)";
                }
            } else if (ap.getWp2g() != null && !(string4 = this.a(ap.getWp2g().getActualChannel())).equals("N/A")) {
                string3 = string4 + "(2.4GHz)";
            }
        }
        if (ap.getRadio5g() != null) {
            string4 = ap.getRadio5g().getChannel();
            if (!string4.equals("0")) {
                string2 = com.tp_link.eap.util.j.b.a((String)com.tp_link.eap.util.j.a.a((Integer)ap.getDeviceMisc().getCustomizeRegion()), (int)Integer.parseInt(string4), (boolean)false);
                if (string2 != null && !(string = this.a(string2)).equals("N/A")) {
                    string3 = string3 + ", " + string + "(5GHz)";
                }
            } else if (ap.getWp5g() != null && !(string4 = this.a(ap.getWp5g().getActualChannel())).equals("N/A")) {
                string3 = string3 + ", " + string4 + "(5GHz)";
            }
        }
        return string3;
    }

    private String a(String string) {
        if (string.equals("N/A")) {
            return string;
        }
        String[] stringArray = string.split("/");
        if (stringArray.length <= 0) {
            return "N/A";
        }
        return stringArray[0].trim();
    }

    public String addPictureFileToGridfs(HttpServletRequest request, long pictureSizeMax) {
        CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        String string = "";
        if (commonsMultipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            Iterator iterator = multipartHttpServletRequest.getFileNames();
            while (iterator.hasNext()) {
                MultipartFile multipartFile = multipartHttpServletRequest.getFile((String)iterator.next());
                if (multipartFile == null) continue;
                String string2 = multipartFile.getOriginalFilename();
                try {
                    if (multipartFile.getSize() > pictureSizeMax) {
                        return "large";
                    }
                    InputStream inputStream = com.tp_link.eap.util.i.a.a((String)string2, (InputStream)multipartFile.getInputStream());
                    if (inputStream == null) {
                        return null;
                    }
                    GridFSInputFile gridFSInputFile = this.e.saveGridFSFile(inputStream);
                    if (gridFSInputFile == null) {
                        f.error("saveGridFSFile failed!");
                        return null;
                    }
                    string = gridFSInputFile.getId().toString();
                    return string;
                }
                catch (IOException | IllegalStateException exception) {
                    f.error("Exception occured!");
                    return null;
                }
            }
            f.error("Not found any part?");
            return null;
        }
        f.error("Not Multipart!");
        return null;
    }
}

